libname q 'c:\SasCodeForBook\SASDataSets';
data first; set q.HumanDevelopment;
sqrtpop =   sqrt(populat);
        /*makes corruption typology*/
coruptyp = .;
if 1 le corrupt < 3 then coruptyp = 4;
if 3 le corrupt le 3.3 then coruptyp = 3;
if 3.4 le corrupt le 5 then coruptyp = 2;
if 5.01 le corrupt le 11 then coruptyp = 1;

        /*makes region typology*/
Fretyp99 = . ;
if free399 = 'F' then fretyp99 = 1;
if free399 = 'P' or free399 = 'PF' then fretyp99 = 2;
if free399 = 'NF' then fretyp99 = 3;

 /*The following creates a flat file with no missing data, s stands for signal*/

sregion = .;
if region = '01e' or region = '01m' or region = '01n' or region = '01s' or
region = '01w' then sregion = 1;
if region = '02' then sregion = 1;
if region = '03c' or region = '03ca' or region = '03sa' or region = '04e' or
region = '04sc' or region = '04se' or region = '04w' then sregion = 1;
if region = '05e' or region = '05n' or region = '05s' or region = '05w' then sregion = 1;
if region = '06' then sregion = 1;

sculture = .;
if culture = 'african' or culture = 'buddhist' or culture = 'hindu' or culture = 'islamic'
or culture = 'japan' or culture = 'latin' or culture = 'orthodox' or culture = 'sinic' or
culture = 'western' then sculture = 1;

sfretyp9 = .;
if fretyp99 ne . then sfretyp9 = 1;

sdebt = .;
if debt ne . then sdebt = 1;

sconflic = .;
if conflict ne . then sconflic = 1;

scorupt = .;
if coruptyp ne . then scorupt = 1;


sslave = .;
if slave98 ne . then sslave = 1;

fulslave = .;
if (slavery  ne . or slavery ne 0) then fulslave = 1;

shdirank = .;
if hdirank ne . then shdirank = 1;

/*signal=1 will eliminate cases that have some missing, so data set has 138 cases*/

signal = scorupt * sconflic * sdebt * sfretyp9 * sculture * sregion *sslave * shdirank;
run;

data explore; set first;

	/* This code creates indicator variables with the low value = 2 and the high value = 1.
	This coding reverses the effect of the Class statement when these variables are treated
	as Class variables.*/

lodebt = 1;
if debt = 2 then lodebt = 2;
if debt = . then lodebt = .;

dichofre = 2;
if fretyp99 = 1 then dichofre = 1;
if fretyp99 = . then dichofre = .;

integrit = 2;
if coruptyp = 1 then integrit =1;
if coruptyp = . then integrit = .;

emancip = . ;
if slavery = 3 or slavery = 4 then emancip = 2;
if slavery = 1 or slavery = 2 then emancip = 1;

nochaos = 1;
if conflict = . then nochaos = .;
if conflict > 0 then nochaos = 2;

run;

data explore; set explore;

if signal = 1;
	/* Table 7.6 replicates the explanatory analysis of Table 7.3 using HDI scores (HDIIndex)
	rather than HDI rank (HDIRank) as the response variable. The dichotomized measures of
	the instrumental freedoms are covariates. The nesting variables are Class
	variables thus necessitating the coding of the instrumental factors as 1 or 2.
	Here s is the appreviation for solution. The parms nobounds statement implements the 
	likelihood ratio test and changes the confidence limits.*/

Title ' 1.  Intercepts Only, Mixed weighted, no nesting,  HDI scores (HDIIndex)';
proc mixed covtest ratio  cl=wald ;
	class culture region;
	model hdiindex = /s ;
	random region /solution; weight sqrtpop;
	parms/nobound;  
run;

Title ' 2. Full Model, Mixed weighted, no nesting,  HDI scores (HDIIndex)';
proc mixed covtest ratio  cl=wald ;
	class region culture emancip dichofre lodebt nochaos integrit ;
	model hdiindex = culture emancip dichofre lodebt nochaos integrit /s ;
	random region /solution; 
	weight sqrtpop;
	parms/nobound;  
run;

Title '3.  Full Model, Mixed weighted, nesting by culture and no chaos, HDI scores (HDIIndex)';
proc mixed covtest ratio  cl=wald ;
	class culture region emancip dichofre lodebt nochaos integrit;
	model hdiindex = culture emancip dichofre lodebt nochaos integrit /s ;
	random region (culture nochaos) /solution;
	weight sqrtpop;
	parms/nobound;  
run;

Title '4. Full Model, Mixed weighted, nesting by slavery and no chaos, HDI scores (HDIIndex)';
proc mixed covtest ratio  cl=wald ;
	class culture region emancip dichofre lodebt nochaos integrit slave98;
	model hdiindex = culture emancip dichofre lodebt nochaos integrit /s ;
	random region (slave98 nochaos) /solution;
	weight sqrtpop;
	parms/nobound;  
run;
		/*This model is not reported in Table 7.6*/
Title '4a. Full Model, Mixed weighted, nesting by binary slavery & no chaos, HDI scores (HDIIndex)';
proc mixed covtest ratio  cl=wald ;
	class culture region emancip dichofre lodebt nochaos integrit slave98;
	model hdiindex = culture emancip dichofre lodebt nochaos integrit /s ;
	random region (emancip nochaos) /solution; weight sqrtpop;
	parms/nobound;  
run;

Title '5. Full Model, Mixed weighted, nesting by full democracy & no chaos, HDI scores(HDIindex)';
proc mixed covtest ratio  cl=wald ;
	class culture region emancip dichofre lodebt nochaos integrit ;
	model hdiindex = culture emancip dichofre lodebt nochaos integrit /s ;
	random region (dichofre nochaos) /solution; 
	weight sqrtpop;
	parms/nobound;  
run;

Title '6. Full Model, Mixed weighted, nesting by low debt & no chaos, HDI scores (HDIindex)';
proc mixed covtest ratio  cl=wald ;
	class culture region emancip dichofre lodebt nochaos integrit ;
	model hdiindex = culture emancip dichofre lodebt nochaos integrit /s ;
	random region (lodebt nochaos)/solution; 
	weight sqrtpop;
	parms/nobound;  
run;
		/*This model is not reported in Table 7.6*/
Title '6a. Full Model, Mixed weighted, nesting by low debt, HDI scores (HDIindex)';
proc mixed covtest ratio  cl=wald ;
	class culture region emancip dichofre lodebt nochaos integrit ;
	model hdiindex = culture emancip dichofre lodebt nochaos integrit /s ;
	random region (lodebt)/solution;
	weight sqrtpop;
	parms/nobound;  
run;

Title '7. Full Model, Mixed weighted, nesting by no chaos, HDI scores (HDIindex)';
proc mixed covtest ratio  cl=wald ;
	class culture region emancip dichofre lodebt nochaos integrit ;
	model hdiindex = culture emancip dichofre lodebt nochaos integrit /s ;
	random region(nochaos) /solution;
	weight sqrtpop;
	parms/nobound;  
run;

Title '8. Full Model, Mixed weighted, nesting by no chaos and integrity,HDI Scores (HDIindex)';
proc mixed covtest ratio  cl=wald ;
class culture region emancip dichofre lodebt nochaos integrit ;
	model hdiindex = culture emancip dichofre lodebt nochaos integrit /s ;
	random region(nochaos integrit) /solution; 
	weight sqrtpop;
	parms/nobound;  
run;

		/* The syntax for Table 7.6 is now complete*/
		/* The syntax in this file is copyright by Robert B. Smith  2011*/













